// DynaImage v2.0 by Radnen

function DynaImage(object, x, y)
{
	if (!this instanceof DynaImage) return new DynaImage(object, x, y);

	if (typeof object == "string") this.img = LoadImage(object);
	else this.img = object;
	this.width = this.img.width;
	this.height = this.img.height;
	this.x = x || 0; this.y = y || 0;
	this.xv = this.x; this.yv = this.y;
	this.nx = this.x; this.ny = this.y;
	this.sx = this.x; this.sy = this.y;
	this.xOff = 0; this.yOff = 0;
	this.color = CreateColor(255, 255, 255);
	this.fTime = 0;
	this.sTime = 0;
	this.fStarted = false;
	this.sStarted = false;
	this.fade = FADE_STOP;
	this.fadeTime = 0;
	this.loopFade = false;
	this.slideTime = null;
	this.fadeDone = true;
	this.slideDone = true;
	this.scrollSpeed = 0;
	this.scrollDir = "east";
	this.onClick = 0;
}

DynaImage.prototype.blit = function(x, y)
{
	if (this.onClick) {
		Cursor.handleUnPress();
		if (Cursor.isWithin(x, y, this.width, this.height) && Cursor.leftClick()) this.onClick();
	}
	this.img.blitMask(x, y, this.color);
}

DynaImage.prototype.setFade = function(type, time)
{
	this.fade = type;
	this.fadeTime = time;
	this.fadeDone = false;
	this.fStarted = false;
	if (type == FADE_IN)  this.color.alpha = 0;
	if (type == FADE_OUT) this.color.alpha = 255;
}

DynaImage.prototype.setSlide = function(x, y, time, type)
{
	if (type === undefined) type = ABSOLUTE;
	this.slideDone = false;
	this.slideTime = time;
	this.sStarted = false;
	if (type == ABSOLUTE) { this.nx = x; this.ny = y; };
	if (type == RELATIVE) { this.nx += x; this.ny += y; };
}

DynaImage.prototype.update = function()
{
	if (!this.sStarted) { this.sTime = GetTime(); this.sStarted = true; }
	if (!this.fStarted) { this.fTime = GetTime(); this.fStarted = true; };
	
	// Update Alpha Color //
	if (this.fTime + this.fadeTime > GetTime() && !this.fadeDone)
	{
		if (this.fade == FADE_IN)  this.color.alpha = (GetTime() - this.fTime) * 255 / this.fadeTime;
		if (this.fade == FADE_OUT) this.color.alpha = 255 - (GetTime() - this.fTime) * 255 / this.fadeTime;
	}
	else if (this.loopFade)
	{
		this.fTime = GetTime();
		if (this.fade == FADE_IN)  this.fade = FADE_OUT;
		else if (this.fade == FADE_OUT) this.fade = FADE_IN;
	}
	else
	{
		this.fadeDone = true;
		if (this.fade == FADE_OUT) this.color.alpha = 0;
		if (this.fade == FADE_IN)  this.color.alpha = 255;
	}
	
	// Update Slide //
	if (this.sTime + this.slideTime > GetTime() && !this.slideDone)
	{
		if (this.nx > this.x) this.xv = this.x + (GetTime() - this.sTime) * (this.nx-this.x) / this.slideTime;
		if (this.nx < this.x) this.xv = this.x - (GetTime() - this.sTime) * (this.x-this.nx) / this.slideTime;
		if (this.ny > this.y) this.yv = this.y + (GetTime() - this.sTime) * (this.ny-this.y) / this.slideTime;
		if (this.ny < this.y) this.yv = this.y - (GetTime() - this.sTime) * (this.y-this.ny) / this.slideTime;
	}
	else
	{
		this.slideDone = true;
		this.xv = this.nx; this.x = this.xv;
		this.yv = this.ny; this.y = this.yv;
	}
	
	this.blit(this.xv, this.yv);
}

DynaImage.prototype.isDone = function()
{
	return (this.slideDone && this.fadeDone);
}

DynaImage.prototype.fadeLoop = function(value)
{
	this.loopFade = value;
}

DynaImage.prototype.setXY = function(x, y)
{
	this.x = x; this.y = y;
	this.xv = this.x; this.yv = this.y;
	this.nx = this.x; this.ny = this.y;
}

DynaImage.prototype.setScroll = function(direction, speed)
{
	this.scrollDir   = direction;
	this.scrollSpeed = speed;
	if (this.scrollDir == "east") this.xOff = -this.width;
	if (this.scrollDir == "west") this.xOff = this.width;
	if (this.scrollDir == "north") this.yOff = this.height;
	if (this.scrollDir == "south") this.yOff = -this.height;
}

DynaImage.prototype.scroll = function()
{
	var date = new Date();
	SetClippingRectangle(this.x, this.y, this.width, this.height);
	if (date.getMilliseconds() % this.scrollSpeed == 0)
	{
		switch (this.scrollDir)
		{
			case "east":
				this.sx++;
				if (this.sx-this.x == this.width) this.sx = 0;
			break;
			case "west":
				this.sx--;
				if (this.x-this.sx == this.width) this.sx = 0;
			break;
			case "north":
				this.sy--;
				if (this.y-this.sy == this.height) this.sy = 0;
			break;
			case "south":
				this.sy++;
				if (this.sy-this.y == this.height) this.sy = 0;
			break;
		}
	}
	
	this.blit(this.sx, this.sy);
	this.blit(this.sx+this.xOff, this.sy+this.yOff);
	SetClippingRectangle(0, 0, SW, SH);
}